


<?php
// Recent Investors data (example provided)
$investors = [
    ['name' => 'Robert Maurice Invested', 'amount' => 550.25],
    ['name' => 'Edna Howland Withdrew', 'amount' => 266.97],
    ['name' => 'John Lawson Invested', 'amount' => 6765.97],
    ['name' => 'Isabel A. Crandall Withdrew', 'amount' => 100.00],
    ['name' => 'Felipe B. Gomez Invested', 'amount' => -56700.33],
    ['name' => 'Fannie Munger Withdrew', 'amount' => 50.00],
    ['name' => 'Raymond J. Hill Invested', 'amount' => 740000.45],
    ['name' => 'Stephen K. Smith Withdrew', 'amount' => 12799.89],
    ['name' => 'David Calvo Invested', 'amount' => 800.00],
    ['name' => 'Jeff Brenton Withdrew', 'amount' => 45799.77],
    ['name' => 'Eugene Rosenthal Invested', 'amount' => 800.00],
    ['name' => 'David F. Wagner Withdrew', 'amount' => 234.78],
    ['name' => 'Phyllis Patin Invested', 'amount' => 7929.06],
    ['name' => 'Pat Mercado Invested', 'amount' => 182.83],
    ['name' => 'Gary Clark Invested', 'amount' => 783.23],
    ['name' => 'Patrick G. Omalley Withdrew', 'amount' => 120.68],
    ['name' => 'Asim Nimr Bata Withdrew', 'amount' => 792.12],
    ['name' => 'Yahyah Nasri Issa Invested', 'amount' => 628.57],
    ['name' => 'Fudail Othman Baba Withdrew', 'amount' => 70.00],
    ['name' => 'Dong Chou Withdrew', 'amount' => 100.00],
    ['name' => 'Li Tsai Invested Withdrew', 'amount' => 50000.00],
    ['name' => 'Peng Jen Invested', 'amount' => 4278.90],
    ['name' => 'Gifford Chnadonnet Withdrew', 'amount' => 428.01],
    ['name' => 'Fabrice Fecteau Invested', 'amount' => 700.00],
    ['name' => 'Sacripant Bédard Withdrew', 'amount' => 200.00],
    ['name' => 'Alexandrin Chauvet Invested', 'amount' => 600.00],
    ['name' => 'Galatee Beausoleil Withdrew', 'amount' => 306.90],
    ['name' => 'Olesya Biryukova Invested', 'amount' => 400.00],
    ['name' => 'Benjamin Fokine Withdrew', 'amount' => 500000.00],
    ['name' => 'Damian Bogolyubov Invested', 'amount' => 226800.00],
    ['name' => 'Moses Ermakov Withdrew', 'amount' => 3000.00],
    ['name' => 'Leon Fink Invested', 'amount' => 800.00],
    ['name' => 'Daniel Osterhagen Withdrew', 'amount' => 60.00],
    ['name' => 'Klaus Gloeckner Invested', 'amount' => 15000.00],
    ['name' => 'Wolfgang Ebersbach Withdrew', 'amount' => 346.98],
    ['name' => 'Tim Fischer Invested', 'amount' => 80.00],
    ['name' => 'Peter Wexler Withdrew', 'amount' => 700000.00],
    ['name' => 'Eric Glockner Withdrew', 'amount' => 1000.00],
    ['name' => 'Thomas Rothschild Invested', 'amount' => 57.82],
    ['name' => 'Jürgen Frankfurter Withdrew', 'amount' => 68.90],
    ['name' => 'Philipp Schroder Withdrew', 'amount' => 783.80],
    ['name' => 'Satordi Lafrenière Invested', 'amount' => 5728.89],
    ['name' => 'Théodore Grenier Withdrew', 'amount' => 7299.92],
    ['name' => 'Tristan Paimboeuf Invested', 'amount' => 628900.06],
    ['name' => 'Ruggero Siciliani Withdrew', 'amount' => 200.70]
];
?>


<section class="section-style-2 grad-bg-6 coin-right">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-10 col-lg-12">
                <div class="section-title text-center">
                    <h4 data-aos="fade-down" data-aos-duration="2000">Latest Investors and Withdraws</h4>
                    <h2 data-aos="fade-down" data-aos-duration="1500">You can explore the live investments and withdraws</h2>
                </div>
            </div>
        </div>
        <div class="row">
            <!-- Recent Investors -->
            <div class="col-xl-6 col-lg-12">
                <div class="site-card" data-aos="fade-right" data-aos-duration="2000">
                    <div class="site-card-header">
                        <h3 class="title">Recent Investors-  Withdrawal/ Investment</h3>
                    </div>
                    <div class="site-card-body">
                        <div class="site-transactions slider" id="investors-slider">
                            <?php $__currentLoopData = $investors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $investor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="single">
                                    <div class="left">
                                        <div class="icon">
                                            <i icon-name="user-plus"></i>
                                        </div>
                                        <div class="content">
                                            <div class="title"><?php echo e($investor['name']); ?></div>
                                            <div class="date"><?php echo e(now()->subMinutes(rand(1, 1000))->format('Y-m-d H:i:s')); ?></div>
                                        </div>
                                    </div>
                                    <div class="right">
                                        <div class="amount">
                                            <div class="net in">
                                                $<?php echo e(number_format($investor['amount'], 2)); ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</section>

<script>
    // Slider Functionality for Investors and Withdraws
    const sliders = [
        { id: 'investors-slider', slidesToShow: 3 },
        { id: 'withdraws-slider', slidesToShow: 3 }
    ];

    sliders.forEach(({ id, slidesToShow }) => {
        const slider = document.querySelector(`#${id}`);
        const slides = slider.children;
        let index = 0;

        const updateSlides = () => {
            Array.from(slides).forEach((slide, idx) => {
                slide.style.display =
                    idx >= index && idx < index + slidesToShow ? 'flex' : 'none';
            });
        };

        const rotateSlides = () => {
            index += slidesToShow;
            if (index >= slides.length) index = 0;
            updateSlides();
        };

        updateSlides();
        setInterval(rotateSlides, 2000);
    });
</script>

<style>
    .slider {
        display: flex;
        flex-direction: column;
    }

    .single {
        display: none;
        align-items: center;
        justify-content: space-between;
        padding: 10px;
        border-bottom: 1px solid #ddd;
    }

    .single:first-child {
        display: flex;
    }

    .single .icon i {
        font-size: 20px;
        color: #007bff;
    }

    .single .content .title {
        font-size: 16px;
        font-weight: bold;
    }

    .single .content .date {
        font-size: 14px;
        color: #888;
    }

    .single .amount {
        font-size: 16px;
        font-weight: bold;
    }

    .single .net.in {
        color: #28a745;
    }

    .single .net.out {
        color: #dc3545;
    }
</style>
<?php /**PATH /home/hashfcds/public_html/hash1/N/m/app/Providers/../../resources/views/frontend/default/home/include/__recent.blade.php ENDPATH**/ ?>