<?php $__env->startSection('deposit_content'); ?>
    <div class="progress-steps-form">
        <form action="<?php echo e(route('user.deposit.now')); ?>" method="post" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="col-xl-6 col-md-12 mb-3">
                    <label for="gatewaySelect" class="form-label"><?php echo e(__('Payment Method:')); ?></label>
                    <div class="input-group">
                        <select name="gateway_code" id="gatewaySelect" class="site-nice-select">
                            <option selected disabled>--<?php echo e(__('Select Gateway')); ?>--</option>
                            <?php $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($gateway->gateway_code); ?>"><?php echo e($gateway->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="input-info-text charge"></div>
                </div>
                <div class="col-xl-6 col-md-12">
                    <label for="amount" class="form-label"><?php echo e(__('Enter Amount:')); ?></label>
                    <div class="input-group">
                        <input type="text" name="amount" class="form-control"
                               oninput="this.value = validateDouble(this.value)" aria-label="Amount" id="amount"
                               aria-describedby="basic-addon1">
                        <span class="input-group-text" id="basic-addon1"><?php echo e($currency); ?></span>
                    </div>
                    <div class="input-info-text min-max"></div>
                </div>

            </div>

            <div class="row manual-row">

            </div>

            <div class="transaction-list table-responsive">
                <div class="user-panel-title">
                    <h3><?php echo e(__('Review Details:')); ?></h3>
                </div>
                <table class="table">
                    <tbody>
                    <tr>
                        <td><strong><?php echo e(__('Amount')); ?></strong></td>
                        <td><span class="amount"></span> <span class="currency"></span></td>
                    </tr>
                    <tr>
                        <td><strong><?php echo e(__('Charge')); ?></strong></td>
                        <td class="charge2"></td>
                    </tr>
                    <tr>
                        <td><strong><?php echo e(__('Payment Method')); ?></strong></td>
                        <td id="logo"><img src="" class="payment-method" alt=""></td>
                    </tr>
                    <tr>
                        <td><strong><?php echo e(__('Total')); ?></strong></td>
                        <td class="total"></td>
                    </tr>

                    <tr class="conversion">
                        <td><strong><?php echo e(__('Conversion Rate')); ?></strong></td>
                        <td class="conversion-rate"></td>
                    </tr>
                    <tr class="conversion">
                        <td><strong><?php echo e(__('Pay Amount')); ?></strong></td>
                        <td class="pay-amount"></td>
                    </tr>


                    </tbody>
                </table>
            </div>
            <div class="buttons">
                <button type="submit" class="site-btn blue-btn">
                    <?php echo e(__('Proceed to Payment')); ?><i class="anticon anticon-double-right"></i>
                </button>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>

        var globalData;
        var currency = <?php echo json_encode($currency, 15, 512) ?>

        $("#gatewaySelect").on('change', function (e) {
            "use strict"
            e.preventDefault();
            $('.manual-row').empty();
            var code = $(this).val()
            var url = '<?php echo e(route("user.deposit.gateway",":code")); ?>';
            url = url.replace(':code', code);
            $.get(url, function (data) {

                globalData = data;

                if (data.currency === currency) {
                    $('.conversion').addClass('hidden');
                } else {
                    $('.conversion').removeClass('hidden');
                }

                $('.charge').text('Charge ' + data.charge + ' ' + (data.charge_type === 'percentage' ? ' % ' : currency))
                $('.conversion-rate').text('1' + ' ' + currency + ' = ' + data.rate + ' ' + data.currency)


                $('.min-max').text('Minimum ' + data.minimum_deposit + ' ' + currency + ' and ' + 'Maximum ' + data.maximum_deposit + ' ' + currency)
                $('#logo').html(`<img class="payment-method" src='${data.gateway_logo}'>`);
                var amount = $('#amount').val()

                if (Number(amount) > 0) {
                    $('.amount').text((Number(amount)))
                    var charge = data.charge_type === 'percentage' ? calPercentage(amount, data.charge) : data.charge
                    $('.charge2').text(charge + ' ' + currency)
                    $('.total').text((Number(amount) + Number(charge)) + ' ' + currency)
                }

                if (data.credentials !== undefined) {
                    $('.manual-row').append(data.credentials)
                    imagePreview()
                }

            });

            $('#amount').on('keyup', function (e) {
                "use strict"
                var amount = $(this).val()
                $('.amount').text((Number(amount)))
                $('.currency').text(currency)

                var charge = globalData.charge_type === 'percentage' ? calPercentage(amount, globalData.charge) : globalData.charge
                $('.charge2').text(charge + ' ' + currency)

                var total = (Number(amount) + Number(charge));

                $('.total').text(total + ' ' + currency)

                $('.pay-amount').text(total * globalData.rate + ' ' + globalData.currency)
            })


        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend::deposit.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hashfcds/public_html/n/m/app/Providers/../../resources/views/frontend/default/deposit/now.blade.php ENDPATH**/ ?>