<div class="panel-header">
    <div class="logo">
        <a href="<?php echo e(route('home')); ?>">
            <img class="logo-unfold" src="<?php echo e(asset(setting('site_logo','global'))); ?>" alt="Logo"/>
            <img class="logo-fold" src="<?php echo e(asset(setting('site_logo','global'))); ?>" alt="Logo"/>
        </a>
    </div>
    <div class="nav-wrap">
        <div class="nav-left">
            <button class="sidebar-toggle">
                <i class="anticon anticon-arrow-left"></i>
            </button>
            <div class="mob-logo">
                <a href="<?php echo e(route('home')); ?>">
                    <img src="<?php echo e(asset(setting('site_logo','global'))); ?>" alt="Site Name"/>
                </a>
            </div>
        </div>
        <div class="nav-right">
            <div class="single-nav-right">

                <div class="single-right">
                    <div class="color-switcher">
                        <i icon-name="moon" class="dark-icon" data-mode="dark"></i>
                        <i icon-name="sun" class="light-icon" data-mode="light"></i>
                    </div>
                </div>

                
                <?php if(auth()->guard()->check()): ?>
                    <?php
                        $userId = auth()->id();
                        $notifications = App\Models\Notification::where('for','user')->where('user_id', $userId)->latest()->take(10)->get();
                        $totalUnread = App\Models\Notification::where('for','user')->where('user_id', $userId)->where('read', 0)->count();
                        $totalCount = App\Models\Notification::where('for','user')->where('user_id', $userId)->get()->count();
                    ?>
                    <div class="single-nav-right user-notifications<?php echo e($userId); ?>">
                        <?php echo $__env->make('global.__notification_data',['notifications'=>$notifications,'totalUnread'=>$totalUnread,'totalCount'=>$totalCount], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                <?php endif; ?>
                

                <div class="single-right">
                    <select name="language" id="" class="site-nice-select"
                            onchange="window.location.href=this.options[this.selectedIndex].value;">
                        <?php $__currentLoopData = \App\Models\Language::where('status',true)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option
                                value="<?php echo e(route('language-update',['name'=> $lang->locale])); ?>" <?php if(App::currentLocale() == $lang->locale ): echo 'selected'; endif; ?>><?php echo e($lang->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="single-right">
                    <button
                        type="button"
                        class="item"
                        data-bs-toggle="dropdown"
                        aria-expanded="false"
                    >
                        <i class="anticon anticon-user"></i>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li>
                            <a href="<?php echo e(route('user.setting.show')); ?>" class="dropdown-item" type="button"><i
                                    class="anticon anticon-setting"></i><?php echo e(__('Settings')); ?></a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('user.change.password')); ?>" class="dropdown-item" type="button">
                                <i class="anticon anticon-lock"></i><?php echo e(__('Change Password')); ?>

                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('user.ticket.index')); ?>" class="dropdown-item" type="button">
                                <i class="anticon anticon-customer-service"></i><?php echo e(__('Support Tickets')); ?>

                            </a>
                        </li>
                        <li class="logout">
                            <form method="POST" action="<?php echo e(route('logout')); ?>" id="logout-form">
                                <?php echo csrf_field(); ?>
                                <a href="<?php echo e(url('logout')); ?>" class="dropdown-item"
                                   onclick="event.preventDefault(); localStorage.clear();  $('#logout-form').submit();"><i
                                        class="anticon anticon-logout"></i><?php echo e(__('Logout')); ?></a>
                            </form>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->startPush('script'); ?>
    <script>
        // Color Switcher
        $(".color-switcher").on('click', function () {
            "use strict"
            $("body").toggleClass("dark-theme");
            var url = '<?php echo e(route("mode-theme")); ?>';
            $.get(url)
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/hashfcds/public_html/hash1/n/m/app/Providers/../../resources/views/frontend/default/include/__user_header.blade.php ENDPATH**/ ?>