<?php $__env->startSection('navigation_content'); ?>

    <div class="col-xl-12">
        <div class="site-card">
            <div class="site-card-header">
                <h3 class="title"><?php echo e(__('All Menu Items')); ?></h3>
                <div class="card-header-links">
                    <a href="" class="card-header-link" type="button" data-bs-toggle="modal"
                       data-bs-target="#addNewNavMenu"><?php echo e(__('Add New')); ?></a>
                </div>
            </div>
            <div class="site-card-body">
                <div class="site-table table-responsive mb-0">
                    <table class="table mb-0">
                        <thead>
                        <tr>
                            <th scope="col"><?php echo e(__('Menu Item Name')); ?></th>
                            <th scope="col"><?php echo e(__('Menu URL')); ?></th>
                            <th scope="col"><?php echo e(__('Page')); ?></th>
                            <th scope="col"><?php echo e(__('Display In')); ?></th>
                            <th scope="col"><?php echo e(__('Status')); ?></th>
                            <th scope="col"><?php echo e(__('Action')); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $navigations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $navigation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <strong><?php echo e($navigation->name); ?></strong>
                                </td>
                                <td><?php echo e($navigation->url); ?></td>
                                <td><strong
                                        class="site-badge primary"><?php echo e($navigation?->page->title ?? 'Custom Url'); ?></strong>
                                </td>
                                <td><strong><?php echo e($navigation->type); ?></strong></td>

                                <td>
                                    <?php if($navigation->status): ?>
                                        <div class="site-badge success" )><?php echo e(__('Active')); ?></div>
                                    <?php else: ?>
                                        <div class="site-badge pending" )><?php echo e(__('DeActive')); ?></div>
                                    <?php endif; ?>
                                </td>

                                <td>
                                    <a class="round-icon-btn blue-btn"
                                       href="<?php echo e(route('admin.navigation.translate',$navigation->id)); ?>">
                                        <i icon-name="languages"></i>
                                    </a>
                                    <button class="round-icon-btn primary-btn editNavMenu"
                                            data-id="<?php echo e($navigation->id); ?>" type="button">
                                        <i icon-name="edit-3"></i>
                                    </button>
                                    <button class="round-icon-btn red-btn deleteMainMenuItem" type="button"
                                            data-id="<?php echo e($navigation->id); ?>">
                                        <i icon-name="trash-2"></i>
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal for Add New Nav Menu -->
    <?php echo $__env->make('backend.navigation.include.__add_new', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Modal for Add New Nav Menu-->

    <!-- Modal for Add New Nav Menu -->
    <?php echo $__env->make('backend.navigation.include.__edit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Modal for Add New Nav Menu-->

    <!-- Modal for Delete Menu -->
    <?php echo $__env->make('backend.navigation.include.__delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Modal for Delete Menu End-->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        $('#page-select').on('change', function (e) {
            "use strict"
            var page = $(this).val();
            $('.custom-url-input').addClass('hidden')
            if (page === 'custom') {
                $('.custom-url-input').removeClass('hidden')
            }
        })

        $('.editNavMenu').on('click', function (e) {
            "use strict"
            var id = $(this).data('id');
            $('.edit-section').empty();
            $.get('menu-edit/' + id, function ($data) {
                $('.edit-section').append($data)
                $('#editNavMenu').modal('show');

            })

        })


        $('body').on('change', '.edit-page-select', function (e) {
            e.preventDefault();
            "use strict"
            var page = $(this).val();
            $('.edit-custom-url-input').addClass('hidden')
            if (page === 'custom') {
                $('.edit-custom-url-input').removeClass('hidden')
            }
        })


        $('.deleteMainMenuItem').on('click', function (e) {
            "use strict"
            var id = $(this).data('id');
            $('.menuId').val(id);
            $('#deleteMenu').modal('toggle')

        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.navigation.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\hashprism\resources\views/backend/navigation/menu.blade.php ENDPATH**/ ?>