## Orders

### Create order

```php
$api->order->create(array('receipt' => '123', 'amount' => 100, 'currency' => 'INR', 'notes'=> array('key1'=> 'value3','key2'=> 'value2')));
```

**Parameters:**

| Name            | Type    | Description                                                                                                                                                                                 |
|-----------------|---------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| amount*         | integer | Amount of the order to be paid                                                                                                                                                              |
| currency*       | string  | Currency of the order. Currently only `INR` is supported.                                                                                                                                   |
| receipt         | string  | Your system order reference id.                                                                                                                                                             |
| notes           | array   | A key-value pair                                                                                                                                                                            |
| partial_payment | boolean | Indicates whether customers can make partial payments on the invoice . Possible values: true - Customer can make partial payments. false (default) - Customer cannot make partial payments. |

**Response:**

```json
{
  "id": "order_EKwxwAgItmmXdp",
  "entity": "order",
  "amount": 50000,
  "amount_paid": 0,
  "amount_due": 50000,
  "currency": "INR",
  "receipt": "receipt#1",
  "offer_id": null,
  "status": "created",
  "attempts": 0,
  "notes": [],
  "created_at": 1582628071
}
```

-------------------------------------------------------------------------------------------------------

### Create order (Third party validation)

```php
$api->order->create(array('amount' => 500, 'receipt' => 'BILL13375649', 'method' => 'netbanking', 'currency' => 'INR', 'bank_account'=> array('account_number'=> '765432123456789','name'=> 'Gaurav Kumar','ifsc'=>'HDFC0000053')));
```

**Parameters:**

| Name         | Type    | Description                                                                                                                                                                                                   |
|--------------|---------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| amount*      | integer | Amount of the order to be paid                                                                                                                                                                                |
| method       | string  | The payment method used to make the payment. If this parameter is not passed, customers will be able to make payments using both netbanking and UPI payment methods. Possible values is `netbanking` or `upi` |
| notes        | array   | A key-value pair                                                                                                                                                                                              |
| currency*    | string  | Currency of the order. Currently only `INR` is supported.                                                                                                                                                     |
| receipt      | string  | Your system order reference id.                                                                                                                                                                               |
| notes        | array   | A key-value pair                                                                                                                                                                                              |
| bank_account | array   | All keys listed [here](https://razorpay.com/docs/payments/third-party-validation/#step-2-create-an-order) are supported                                                                                       |

**Response:**

```json
{
  "id": "order_GAWN9beXgaqRyO",
  "entity": "order",
  "amount": 500,
  "amount_paid": 0,
  "amount_due": 500,
  "currency": "INR",
  "receipt": "BILL13375649",
  "offer_id": null,
  "status": "created",
  "attempts": 0,
  "notes": [],
  "created_at": 1573044247
}
```

-------------------------------------------------------------------------------------------------------

### Fetch all orders

```php
$api->order->all($options);
```

**Parameters**

| Name       | Type      | Description                                                                                                                              |
|------------|-----------|------------------------------------------------------------------------------------------------------------------------------------------|
| from       | timestamp | timestamp after which the orders were created                                                                                            |
| to         | timestamp | timestamp before which the orders were created                                                                                           |
| count      | integer   | number of orders to fetch (default: 10)                                                                                                  |
| skip       | integer   | number of orders to be skipped (default: 0)                                                                                              |
| authorized | boolean   | Orders for which orders are currently in authorized state.                                                                               |
| receipt    | string    | Orders with the provided value for receipt.                                                                                              |
| expand[]   | string    | Used to retrieve additional information about the payment. Possible value is `payments`,`payments.card`,`transfers` or `virtual_account` |

**Response:**

```json
{
  "entity": "collection",
  "count": 1,
  "items": [
    {
      "id": "order_EKzX2WiEWbMxmx",
      "entity": "order",
      "amount": 1234,
      "amount_paid": 0,
      "amount_due": 1234,
      "currency": "INR",
      "receipt": "Receipt No. 1",
      "offer_id": null,
      "status": "created",
      "attempts": 0,
      "notes": [],
      "created_at": 1582637108
    }
  ]
}
```

-------------------------------------------------------------------------------------------------------

### Fetch particular order

```php
$api->order->fetch($orderId);
```

**Parameters**

| Name     | Type   | Description                       |
|----------|--------|-----------------------------------|
| orderId* | string | The id of the order to be fetched |

**Response:**

```json
{
    "id": "order_IXnOAMw6SSqKvN",
    "entity": "order",
    "amount": 100,
    "amount_paid": 0,
    "amount_due": 100,
    "currency": "INR",
    "receipt": "Receipt no. 1",
    "offer_id": null,
    "status": "created",
    "attempts": 0,
    "notes": {
        "notes_key_1": "Tea, Earl Grey, Hot",
        "notes_key_2": "Tea, Earl Grey… decaf."
    },
    "created_at": 1639581113
}
```

-------------------------------------------------------------------------------------------------------

### Fetch payments for an order

```php
$api->order->fetch($orderId)->payments();
```

**Parameters**

| Name     | Type   | Description                                     |
|----------|--------|-------------------------------------------------|
| orderId* | string | The id of the order to be retrieve payment info |

**Response:**

```json
{
  "entity":"collection",
  "count":1,
  "items":[
    {
      "id":"pay_DaaSOvhgcOfzgR",
      "entity":"payment",
      "amount":2200,
      "currency":"INR",
      "status":"captured",
      "order_id":"order_DaaS6LOUAASb7Y",
      "invoice_id":null,
      "international":false,
      "method":"card",
      "amount_refunded":0,
      "refund_status":null,
      "captured":true,
      "description":"Beans in every imaginable flavour",
      "card_id":"card_DZon6fd8J3IcA2",
      "bank":null,
      "wallet":null,
      "vpa":null,
      "email":"gaurav.kumar@example.com",
      "contact":"+919999999988",
      "notes":[],
      "fee":44,
      "tax":0,
      "error_code":null,
      "error_description":null,
      "created_at":1572505160
    }
  ]
}
```

-------------------------------------------------------------------------------------------------------

### Update order

```php
$api->order->fetch($orderId)->edit(array('notes'=> array('notes_key_1'=>'Beam me up Scotty. 1', 'notes_key_2'=>'Engage')));
```

**Parameters**

| Name     | Type   | Description                                     |
|----------|--------|-------------------------------------------------|
| orderId* | string | The id of the order to be retrieve payment info |
| notes*   | array  | A key-value pair                                |

**Response:**

```json
{
  "id":"order_DaaS6LOUAASb7Y",
  "entity":"order",
  "amount":2200,
  "amount_paid":0,
  "amount_due":2200,
  "currency":"INR",
  "receipt":"Receipt #211",
  "offer_id":null,
  "status":"attempted",
  "attempts":1,
  "notes":{
    "notes_key_1":"Tea, Earl Grey, Hot",
    "notes_key_2":"Tea, Earl Grey… decaf."
  },
  "created_at":1572505143
}
```

-------------------------------------------------------------------------------------------------------


**PN: * indicates mandatory fields**
<br>
<br>
**For reference click [here](https://razorpay.com/docs/api/orders/)**
