<?php $__env->startSection('title'); ?>
    <?php echo e(__('Register')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <!-- Login Section -->
    <section class="section-style site-auth">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-8 col-md-12">
                    <div class="auth-content">
                        <div class="logo">
                            <a href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset(setting('site_logo','global'))); ?>" alt=""/></a>
                        </div>
                        <div class="title">
                            <h2> <?php echo e($data['title']); ?></h2>
                            <p><?php echo e($data['bottom_text']); ?></p>
                        </div>
                        <?php if($errors->any()): ?>
                            <div class="alert alert-warning alert-dismissible fade show" role="alert">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <strong><?php echo e(__('You Entered')); ?> <?php echo e($error); ?></strong>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                        aria-label="Close"></button>
                            </div>
                        <?php endif; ?>


                        <div class="site-auth-form">
                            <form method="POST" action="<?php echo e(route('register')); ?>" class="row">
                                <?php echo csrf_field(); ?>
                                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                                    <div class="single-field">
                                        <label class="box-label" for="name"><?php echo e(__('First Name')); ?><span
                                                class="required-field">*</span></label>
                                        <input
                                            class="box-input"
                                            type="text"
                                            placeholder="Your First Name"
                                            name="first_name"
                                            value="<?php echo e(old('first_name')); ?>"
                                            required
                                        />
                                    </div>
                                </div>

                                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                                    <div class="single-field">
                                        <label class="box-label" for="name"><?php echo e(__('Last Name')); ?><span
                                                class="required-field">*</span></label>
                                        <input
                                            class="box-input"
                                            type="text"
                                            placeholder="Your Last Name"
                                            name="last_name"
                                            value="<?php echo e(old('last_name')); ?>"
                                            required
                                        />
                                    </div>
                                </div>
                                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                                    <div class="single-field">
                                        <label class="box-label" for="email"><?php echo e(__('Email Address')); ?><span
                                                class="required-field">*</span></label>
                                        <input
                                            class="box-input"
                                            type="email"
                                            name="email"
                                            value="<?php echo e(old('email')); ?>"
                                            placeholder="Enter Your Email Address"
                                            required
                                        />
                                    </div>
                                </div>

                                <?php if(getPageSetting('username_show')): ?>
                                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                                        <div class="single-field">
                                            <label class="box-label" for="username"><?php echo e(__('User Name')); ?><span
                                                    class="required-field">*</span></label>
                                            <input
                                                class="box-input"
                                                type="text"
                                                placeholder="Enter Your User Name"
                                                name="username"
                                                value="<?php echo e(old('username')); ?>"
                                                required
                                            />
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php if(getPageSetting('country_show')): ?>
                                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                                        <div class="single-field">
                                            <label class="box-label" for="username"><?php echo e(__('Select Country')); ?><span
                                                    class="required-field">*</span></label>

                                            <select name="country" id="countrySelect" class="site-nice-select">

                                                <?php $__currentLoopData = getCountries(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php if( $location->country_code == $country['code']): ?> selected
                                                            <?php endif; ?> value="<?php echo e($country['name'].':'.$country['dial_code']); ?>">
                                                        <?php echo e($country['name']); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            </select>

                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php if(getPageSetting('phone_show')): ?>
                                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                                        <div class="single-field">
                                            <label class="box-label" for="username"><?php echo e(__('Phone Number')); ?><span
                                                    class="required-field">*</span></label>
                                            <div class="input-group joint-input"><span class="input-group-text"
                                                                                       id="dial-code"><?php echo e(getLocation()->dial_code); ?></span>
                                                <input
                                                    type="text"
                                                    class="form-control"
                                                    placeholder="Phone Number"
                                                    name="phone"
                                                    value="<?php echo e(old('phone')); ?>"
                                                    aria-label="Username"
                                                    aria-describedby="basic-addon1"
                                                />
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <?php if(getPageSetting('referral_code_show')): ?>
                                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                                        <div class="single-field">
                                            <label class="box-label"
                                                   for="invite"><?php echo e(__('Referral Code')); ?></label>
                                            <input
                                                class="box-input"
                                                type="text"
                                                placeholder="Enter Your Referral Code"
                                                name="invite"
                                                value="<?php echo e(request('invite') ?? old('invite')); ?>"
                                            />
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                                    <div class="single-field">
                                        <label class="box-label" for="password"><?php echo e(__('Password')); ?><span
                                                class="required-field">*</span></label
                                        >
                                        <div class="password">
                                            <input
                                                class="box-input"
                                                type="password"
                                                name="password"
                                                placeholder="Enter your password"
                                                required
                                            />
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                                    <div class="single-field">
                                        <label class="box-label" for="password"><?php echo e(__('Confirm Password')); ?><span
                                                class="required-field">*</span></label>
                                        <div class="password">
                                            <input
                                                class="box-input"
                                                type="password"
                                                name="password_confirmation"
                                                placeholder="Enter your password"
                                                required
                                            />
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12 col-lg-12 col-md-12 col-12">
                                    <div class="single-field">
                                        <?php if($googleReCaptcha): ?>
                                            <div class="g-recaptcha" id="feedback-recaptcha"
                                                 data-sitekey="<?php echo e(json_decode($googleReCaptcha->data,true)['google_recaptcha_key']); ?>">
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-xl-12 col-lg-12 col-md-12 col-12">
                                    <div class="single-field">
                                        <input
                                            class="form-check-input check-input"
                                            type="checkbox"
                                            name="i_agree"
                                            value="yes"
                                            id="flexCheckDefault"
                                            required
                                        />
                                        <label class="form-check-label" for="flexCheckDefault">
                                            <?php echo e(__('I agree with')); ?>

                                            <a href="<?php echo e(url('/privacy-policy')); ?>"><?php echo e(__('Privacy & Policy')); ?></a> <?php echo e(__('and')); ?>

                                            <a href="<?php echo e(url('/terms-and-conditions')); ?>"><?php echo e(__('Terms & Condition')); ?></a>
                                        </label>
                                    </div>
                                </div>


                                <div class="col-xl-12">
                                    <button type="submit" class="site-btn grad-btn w-100">
                                        <?php echo e(__('Create Account')); ?>

                                    </button>
                                </div>
                            </form>
                            <div class="singnup-text">
                                <p><?php echo e(__('Already have an account?')); ?> <a
                                        href="<?php echo e(route('login')); ?>"><?php echo e(__('Login')); ?></a></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Login Section End -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <?php if($googleReCaptcha): ?>
        <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <?php endif; ?>
    <script>
        $('#countrySelect').on('change', function (e) {
            "use strict";
            e.preventDefault();
            var country = $(this).val();
            $('#dial-code').html(country.split(":")[1])
        })
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('frontend::layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hashfcds/public_html/app/Providers/../../resources/views/frontend/default/auth/register.blade.php ENDPATH**/ ?>