<?php $__env->startSection('title'); ?>
    <?php echo e(__('Edit Withdraw Method')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('withdraw_content'); ?>
    <div class="container-fluid">
        <div class="row justify-content-center">
            <div class="col-xl-8">
                <div class="site-card">
                    <div class="site-card-body">
                        <form action="<?php echo e(route('admin.withdraw.method.update',$withdrawMethod->id)); ?>" class="row"
                              method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="type" value="<?php echo e($type); ?>">
                            <div class="col-xl-12">
                                <div class="row">
                                    <div class="col-xl-3">
                                        <div class="site-input-groups">
                                            <label class="box-input-label" for=""><?php echo e(__('Upload Icon:')); ?></label>
                                            <div class="wrap-custom-file">
                                                <input
                                                    type="file"
                                                    name="icon"
                                                    id="schema-icon"
                                                    accept=".gif, .jpg, .png"
                                                />
                                                <label for="schema-icon" <?php if($withdrawMethod->icon): ?>  class="file-ok"
                                                       style="background-image: url(<?php echo e(asset($withdrawMethod->icon)); ?>)" <?php endif; ?>>
                                                    <img
                                                        class="upload-icon"
                                                        src="<?php echo e(asset('global/materials/upload.svg')); ?>"
                                                        alt=""
                                                    />
                                                    <span><?php echo e(__('Update Icon')); ?></span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="site-input-groups">
                                    <label class="box-input-label" for=""><?php echo e(__('Name:')); ?></label>
                                    <input
                                        type="text"
                                        class="box-input"
                                        name="name"
                                        value="<?php echo e($withdrawMethod->name); ?>"
                                    />
                                </div>
                            </div>

                            <?php if($type == 'auto'): ?>
                                <div class="col-xl-6">
                                    <div class="site-input-groups">
                                        <label class="box-input-label"
                                               for=""><?php echo e(__('Gateway Supported Currency:')); ?></label>
                                        <select name="currency" class="form-select" id="currency">
                                            <?php $__currentLoopData = json_decode($supported_currencies); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option
                                                    value="<?php echo e($currency); ?>" <?php if($currency == $withdrawMethod->currency ): echo 'selected'; endif; ?>><?php echo e($currency); ?> </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <?php if($type == 'manual'): ?>
                                <div class="col-xl-6">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for=""><?php echo e(__('Currency:')); ?></label>
                                        <input
                                            type="text"
                                            class="box-input"
                                            name="currency"
                                            value="<?php echo e($withdrawMethod->currency); ?>"
                                            id="currency"
                                        />
                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="col-xl-6">
                                <div class="site-input-groups row">
                                    <div class="col-xl-12">
                                        <label class="box-input-label" for=""><?php echo e(__('Convention Rate:')); ?></label>
                                        <div class="input-group joint-input">
                                            <span
                                                class="input-group-text"><?php echo e('1 '.' '. setting('site_currency','global') . ' ='); ?> </span>
                                            <input type="text" name="rate" class="form-control"
                                                   value="<?php echo e($withdrawMethod->rate); ?>"/>
                                            <span class="input-group-text"
                                                  id="currency-selected"><?php echo e($withdrawMethod->currency); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="site-input-groups position-relative">
                                    <label class="box-input-label" for=""><?php echo e(__('Charges:')); ?></label>
                                    <div class="position-relative">
                                        <input type="text" class="box-input"
                                               oninput="this.value = validateDouble(this.value)" name="charge"
                                               value="<?php echo e($withdrawMethod->charge); ?>"/>
                                        <div class="prcntcurr">
                                            <select name="charge_type" class="form-select">
                                                <option value="percentage"
                                                        <?php if( $withdrawMethod->charge_type == 'percentage'): ?> selected <?php endif; ?>><?php echo e(__('%')); ?></option>
                                                <option value="fixed"
                                                        <?php if( $withdrawMethod->charge_type == 'fixed'): ?> selected <?php endif; ?>><?php echo e($currencySymbol); ?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="site-input-groups">
                                    <label class="box-input-label" for=""><?php echo e(__('Minimum Withdraw:')); ?></label>
                                    <div class="input-group joint-input">
                                        <input type="text" name="min_withdraw" class="form-control"
                                               value="<?php echo e($withdrawMethod->min_withdraw); ?>"/>
                                        <span class="input-group-text"
                                              id="currency-selected"><?php echo e(setting('site_currency','global')); ?></span>
                                    </div>

                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="site-input-groups">
                                    <label class="box-input-label" for=""><?php echo e(__('Maximum Withdraw:')); ?></label>
                                    <div class="input-group joint-input">
                                        <input
                                            type="text"
                                            name="max_withdraw"
                                            class="form-control"
                                            value="<?php echo e($withdrawMethod->max_withdraw); ?>"
                                        />
                                        <span class="input-group-text"
                                              id="currency-selected"><?php echo e(setting('site_currency','global')); ?></span>
                                    </div>
                                </div>
                            </div>
                            <?php if($type == 'manual'): ?>
                                <div class="col-xl-6">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for=""><?php echo e(__('Processing Time:')); ?></label>
                                        <div class="position-relative">
                                            <input type="text" name="required_time"
                                                   value="<?php echo e($withdrawMethod->required_time); ?>" class="box-input mb-0"/>
                                            <div class="prcntcurr">
                                                <select name="required_time_format" class="form-select mb-0">
                                                    <?php $__currentLoopData = ['minute' => 'Minutes','hour' => 'Hours','day' => 'Days' ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option
                                                            <?php if( $withdrawMethod->required_time_format == $key): ?> selected
                                                            <?php endif; ?> value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="col-xl-6">
                                <div class="site-input-groups">
                                    <label class="box-input-label" for=""><?php echo e(__('Status:')); ?></label>
                                    <div class="switch-field same-type">
                                        <input
                                            type="radio"
                                            id="radio-five"
                                            name="status"
                                            value="1"
                                            <?php if($withdrawMethod->status): ?> checked <?php endif; ?>
                                        />
                                        <label for="radio-five"><?php echo e(__('Active')); ?></label>
                                        <input
                                            type="radio"
                                            id="radio-six"
                                            name="status"
                                            value="0"
                                            <?php if(!$withdrawMethod->status): ?> checked <?php endif; ?>
                                        />
                                        <label for="radio-six"><?php echo e(__('Deactivate')); ?></label>
                                    </div>
                                </div>
                            </div>

                            <?php if($type == 'manual'): ?>
                                <div class="col-xl-12">
                                    <a href="javascript:void(0)" id="generate" class="site-btn-xs primary-btn mb-3">Add
                                        Field option</a>
                                </div>

                                <div class="addOptions">
                                    <?php $__currentLoopData = json_decode($withdrawMethod->fields,true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="mb-4">
                                            <div class="option-remove-row row">
                                                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                                                    <div class="site-input-groups">
                                                        <input name="fields[<?php echo e($key); ?>][name]" class="box-input"
                                                               type="text"
                                                               value="<?php echo e($value['name']); ?>" required
                                                               placeholder="Field Name">
                                                    </div>
                                                </div>

                                                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                                                    <div class="site-input-groups">
                                                        <select name="fields[<?php echo e($key); ?>][type]"
                                                                class="form-select form-select-lg mb-3">
                                                            <option value="text"
                                                                    <?php if($value['type'] == 'text'): ?> selected <?php endif; ?>>Input
                                                                Text
                                                            </option>
                                                            <option value="textarea"
                                                                    <?php if($value['type'] == 'textarea'): ?> selected <?php endif; ?>>
                                                                Textarea
                                                            </option>
                                                            <option value="file"
                                                                    <?php if($value['type'] == 'file'): ?> selected <?php endif; ?>>File
                                                                upload
                                                            </option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
                                                    <div class="site-input-groups mb-0">
                                                        <select name="fields[<?php echo e($key); ?>][validation]"
                                                                class="form-select form-select-lg mb-1">
                                                            <option value="required"
                                                                    <?php if($value['validation'] == 'required'): ?> selected <?php endif; ?>>
                                                                Required
                                                            </option>
                                                            <option value="nullable"
                                                                    <?php if($value['validation'] == 'nullable'): ?> selected <?php endif; ?>>
                                                                Optional
                                                            </option>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-xl-1 col-lg-6 col-md-6 col-sm-6 col-12">
                                                    <button class="delete-option-row delete_desc" type="button">
                                                        <i class="fas fa-times"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php endif; ?>

                            <div class="col-xl-12">
                                <button type="submit" class="site-btn primary-btn w-100">
                                    <?php echo e(__('Save Changes')); ?>

                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $("#currency").on('change', function () {
            $('#currency-selected').text(this.value);
        });

        var i = Object.keys(JSON.parse(<?php echo json_encode($withdrawMethod->fields, 15, 512) ?>)).length;
        $("#generate").on('click', function () {
            ++i;
            var form = `<div class="mb-4">
                  <div class="option-remove-row row">
                    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                      <div class="site-input-groups">
                        <input name="fields[` + i + `][name]" class="box-input" type="text" value="" required placeholder="Field Name">
                      </div>
                    </div>

                    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                      <div class="site-input-groups">
                        <select name="fields[` + i + `][type]" class="form-select form-select-lg mb-3">
                            <option value="text">Input Text</option>
                            <option value="textarea">Textarea</option>
                            <option value="file">File upload</option>
                        </select>
                      </div>
                    </div>
                    <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
                      <div class="site-input-groups mb-0">
                        <select name="fields[` + i + `][validation]" class="form-select form-select-lg mb-1">
                            <option value="required">Required</option>
                            <option value="nullable">Optional</option>
                        </select>
                      </div>
                    </div>

                    <div class="col-xl-1 col-lg-6 col-md-6 col-sm-6 col-12">
                      <button class="delete-option-row delete_desc" type="button">
                        <i class="fas fa-times"></i>
                      </button>
                    </div>
                    </div>
                  </div>`;
            $('.addOptions').append(form)
        });

        $(document).on('click', '.delete_desc', function () {
            $(this).closest('.option-remove-row').parent().remove();
        });

        $('#gateway-select').on('change', function () {
            var id = $(this).val();
            var url = '<?php echo e(route('admin.gateway.supported.currency',':id')); ?>';
            url = url.replace(':id', id);
            $.get(url, function ($data) {
                $('#currency').html($data.view);
            })
        })

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.withdraw.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hashfcds/public_html/n/m/resources/views/backend/withdraw/method_edit.blade.php ENDPATH**/ ?>