<?php $__env->startSection('title'); ?>
    <?php echo e(__('Edit Blog')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row justify-content-center">
                    <div class="col-xl-12">
                        <div class="title-content">
                            <h2 class="title"><?php echo e(__('Edit Blog')); ?></h2>

                            <a href="<?php echo e(route('admin.page.edit','blog')); ?>"
                               class="title-btn"
                               type="button"
                            ><i icon-name="layout-list"></i><?php echo e(__('Blog Section')); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="site-tab-bars">
            <ul class="nav nav-pills" id="pills-tab" role="tablist">
                <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="nav-item" role="presentation">
                        <a
                            href=""
                            class="nav-link  <?php echo e($loop->index == 0 ?'active' : ''); ?>"
                            id="pills-informations-tab"
                            data-bs-toggle="pill"
                            data-bs-target="#<?php echo e($language->locale); ?>"
                            type="button"
                            role="tab"
                            aria-controls="pills-informations"
                            aria-selected="true"
                        ><i icon-name="languages"></i><?php echo e($language->name); ?></a
                        >
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


            </ul>
        </div>

        <div class="tab-content" id="pills-tabContent">

            <?php $__currentLoopData = $groupData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                <div
                    class="tab-pane fade <?php echo e($loop->index == 0 ?'show active' : ''); ?>"
                    id="<?php echo e($key); ?>"
                    role="tabpanel"
                    aria-labelledby="pills-informations-tab"
                >

                    <div class="row">
                        <div class="col-xl-12">
                            <div class="site-card">

                                <div class="site-card-body">
                                    <form action="<?php echo e(route('admin.page.blog.update',$blog['id'])); ?>" method="post"
                                          enctype="multipart/form-data">
                                        <?php echo method_field('PUT'); ?>
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="locale" value="<?php echo e($key); ?>">
                                        <div class="site-input-groups row">
                                            <label for="" class="col-sm-3 col-label"><?php echo e(__('Blog Title')); ?><i
                                                    icon-name="info"
                                                    data-bs-toggle="tooltip"
                                                    title=""
                                                    data-bs-original-title="There will be blog title"></i></label>
                                            <div class="col-sm-9">
                                                <input type="text" name="title" value="<?php echo e($blog['title']); ?>"
                                                       class="box-input"
                                                       placeholder="Blog Title" required="">
                                            </div>
                                        </div>

                                        <?php if($key == 'en'): ?>
                                            <div class="site-input-groups row">
                                                <div class="col-xl-3 col-lg-3 col-md-3 col-sm-12 col-label">
                                                    <?php echo e(__('Blog Cover')); ?>

                                                </div>
                                                <div class="col-xl-9 col-lg-9 col-md-9 col-sm-12">
                                                    <div class="wrap-custom-file">
                                                        <input type="file" name="cover" id="cover"
                                                               accept=".gif, .jpg, .png"/>
                                                        <label for="cover" class="file-ok"
                                                               style="background-image: url( <?php echo e(asset( $blog['cover'] )); ?> )">
                                                            <img class="upload-icon"
                                                                 src="<?php echo e(asset('global/materials/upload.svg')); ?>"
                                                                 alt=""/>
                                                            <span><?php echo e(__('Update Image')); ?></span>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>

                                        <div class="site-input-groups row mb-0">
                                            <label for="" class="col-sm-3 col-label"><?php echo e(__('Blog Details')); ?><i
                                                    icon-name="info"
                                                    data-bs-toggle="tooltip"
                                                    title=""
                                                    data-bs-original-title="There will be blog title"></i></label>
                                            <div class="col-sm-9">
                                                <div class="site-input-groups fw-normal">
                                                    <div class="site-editor">
                                                <textarea class="summernote"
                                                          name="details"><?php echo $blog['details']; ?></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="offset-sm-3 col-sm-9">
                                                <button type="submit"
                                                        class="site-btn-sm primary-btn w-100"><?php echo e(__('Update Now')); ?></button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hashfcds/public_html/hash1/n/m/resources/views/backend/page/blog/edit.blade.php ENDPATH**/ ?>