<?php use App\Enums\InvestStatus; ?>

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Dashboard')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <div class="title-content">
                            <h2 class="title"><?php echo e(setting('site_title', 'global')); ?> <?php echo e(__('Dashboard')); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
            <div class="row">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['deposit-action','withdraw-action','kyc-action',])): ?>
                    <?php if($data['withdraw_count'] || $data['kyc_count'] || $data['deposit_count']): ?>
                        <div class="col-xl-12">
                            <div class="admin-latest-announcements">
                                <div class="content"><i
                                        icon-name="zap"></i><?php echo e(__("Explore what's important to review first")); ?></div>
                                <div class="content">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('withdraw-action')): ?>
                                        <?php if($data['withdraw_count']): ?>
                                            <a href="<?php echo e(route('admin.withdraw.pending')); ?>" class="site-btn-xs red-btn"><i
                                                    icon-name="loader"
                                                    class="spining-icon"></i><?php echo e(__('Withdraw Requests')); ?>

                                                (<?php echo e($data['withdraw_count']); ?>)</a>
                                        <?php endif; ?>
                                    <?php endif; ?>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('kyc-action')): ?>
                                        <?php if($data['kyc_count']): ?>
                                            <a href="<?php echo e(route('admin.kyc.pending')); ?>" class="site-btn-xs green-btn"><i
                                                    icon-name="loader" class="spining-icon"></i><?php echo e(__('KYC Requests')); ?>

                                                (<?php echo e($data['kyc_count']); ?>)</a>
                                        <?php endif; ?>
                                    <?php endif; ?>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('deposit-action')): ?>
                                        <?php if($data['deposit_count']): ?>
                                            <a href="<?php echo e(route('admin.deposit.manual.pending')); ?>"
                                               class="site-btn-xs primary-btn"><i icon-name="loader"
                                                                                  class="spining-icon"></i><?php echo e(__('Deposit Requests')); ?>

                                                (<?php echo e($data['deposit_count']); ?>)</a>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
            </div>
            <?php endif; ?>

            <?php echo $__env->make('backend.include.__data_card', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


            <div class="row">
                <div class="col-xl-8 col-lg-12 col-md-12 col-sm-12">
                    <div class="site-chart">
                        <div class="site-card">
                            <div class="site-card-header">
                                <h3 class="title"><?php echo e(__('Site Statistics')); ?></h3>
                                <div class="card-header-links">
                                    <input class="card-header-input" type="text" name="daterange"
                                           value="<?php echo e($data['start_date'] .' - '. $data['end_date']); ?>"/>
                                </div>
                            </div>
                            <div class="site-card-body">
                                <canvas id="depositChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                    <div class="site-chart">
                        <div class="site-card">
                            <div class="site-card-header">
                                <h3 class="title"><?php echo e(__('Scheme Statistics')); ?></h3>
                            </div>
                            <div class="site-card-body">
                                <canvas id="schemeChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                    <div class="site-chart">
                        <div class="site-card">
                            <div class="site-card-header">
                                <h3 class="title"><?php echo e(__('Top Country Statistics')); ?></h3>
                            </div>
                            <div class="site-card-body">
                                <canvas id="countryChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                    <div class="site-chart">
                        <div class="site-card">
                            <div class="site-card-header">
                                <h3 class="title"><?php echo e(__('Best Browser Statistics')); ?></h3>
                            </div>
                            <div class="site-card-body">
                                <canvas id="browserChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                    <div class="site-chart">
                        <div class="site-card">
                            <div class="site-card-header">
                                <h3 class="title"><?php echo e(__('Best OS Statistics')); ?></h3>
                            </div>
                            <div class="site-card-body">
                                <canvas id="osChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php echo $__env->make('backend.include.__latest_user_invest', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        </div>
    </div>
    <!-- Modal for Send Email -->
    <?php echo $__env->make('backend.user.include.__mail_send', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Modal for Send Email-->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <?php echo $__env->make('backend.include.__chartjs', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>
        (function ($) {
            'use strict'
            //send mail modal form open
            $('.send-mail').on('click', function () {
                var id = $(this).data('id')
                var name = $(this).data('name')
                $('#name').html(name)
                $('#userId').val(id)
                $('#sendEmail').modal('toggle')
            })
        })(jQuery)
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\resources\views/backend/dashboard.blade.php ENDPATH**/ ?>